	.include	'eq.s'
	.include	'externs.s'

	.text

;each voice is 20 longs
; 0						set to 7*4 to start 8 bit sample, set to 3*4 to start 16 bit sample
; 1	volume				low 0,	high $7FFF
; 2	data address
; 3	pitch				rate / 156	set to 0 to pause sample
; 4	length of sample data	length / 128
; 5
; 6
; 8
; 9
;10
;11
;12
;13
;14
;15
;16
;17
;18
;19	pan					full left $7FFF	middle $3FFF	full right 0

playsnd::
;---------------------------------------------------------------------
;
;  The sound index is used to find sound in table and to find sound
; priority for comparing against other existing sounds.  The priority
; only matters when all the voices are used up currently and someone
; needs to be bumped.
;
;  VARIABLES NEEDED:
;
;   MAX_VOICES		- this equate defines how many voices we can play with
;   voicepriority	- these are each used voice's current priority
;					(this could be the value we find in voicestatus)
;   voicestatus		- the voice status lets us know if any voices are avialable (either 0 or priority value)
;
;      d0 - pass in sound index
;      d1 - pass in xpos of sound or $00003FFF to use middle pan value
;      a0 - contains address of sample to be played
;      a1 - must be set to appropriate voice table (each of length taboff)
;      a2 - &bits_tbl for looking up 8-bit or 16-bit sample entry for sound header (tablestart + (n * taboff)) where n is voice number
;      a3 - used for samp_priorities lookup; used for voicestatus comparison

	movem.l	a0-a4/d1-d3,-(sp)

;check for a free voice
	move.w	#MAX_VOICES-1,d2
	lea		snd_priorities,a2
	lea		voicestatus,a3
	lea		sndtype,a4
.05:
	tst.b	(a3,d2.w)		;check voicestatus
	beq.b	.20			;if voicepriority <> 0, voice is unavailable (check priorities later)
	dbra		d2,.05

;-------------------------------------------------------------------------------
;if no free voices, then we compare for lower priority sound we can override

	move.w	#MAX_VOICES-1,d2
	move.b	(a2,d0.w),d3			;store priority for requested sound in d3
.07:
	cmp.b	(a3,d2),d3			;compare to requested priority
	bge.b	.20					;if new sound is higher priority than current sound, play new sound
	dbra		d2, .07
	bra		.90					;can't play the sound at this time!!!

; we get here when we have a voice to use (d2) and sound to play (d0)
.20:	move.b	(a2,d0.w),(a3,d2.w)		;store requested sounds priority value in voicestatus table
	move.b	d0,(a4,d2.w)			;save sound number in sndtype table
	cmp.b	#FIRST_FM,d0
	blt.b	.50
	bsr		startfm
	bra.b	.90
.50:	bsr		startsmp				;set up the sound header to actually trigger a sound
.90:
	movem.l	(sp)+,a0-a4/d1-d3
	rts

playvoice::
;	d0 - pass in sound index
;	d1 - sound xpos for pan value
;	d2 - pass in voice number to use
	movem.l	a0-a4/d1-d3,-(sp)
	lea		snd_priorities,a2
	lea		voicestatus,a3
	lea		sndtype,a4
.20:	move.b	(a2,d0.w),(a3,d2.w)		;store requested sounds priority value in voicestatus table
	move.b	d0,(a4,d2.w)			;save sound number in sndtype table
	cmp.b	#FIRST_FM,d0
	blt.b	.50
	bsr		startfm
	bra.b	.90
.50:	bsr		startsmp
.90:	movem.l	(sp)+,a0-a4/d1-d3
	rts


startsmp::
;D0 = sound number
;D1 = sound xpos for pan value
;D2 = voice number to use

	lea		snd_addr,a0
	lsl.w	#2,d0				;sample number * 4 bytes per address
	move.l	(a0,d0.w),a0			;get address of sample

	lea		snd_hdr_tbl,a1
	lsl.w	#2,d2				;voice number * 4
	move.l	(a1,d2.w),a1			;a1 is now the [tablestart + (n * taboff)]

	lea		snd_vol,a2			;volume for each sound
	move.l	(a2,d0.w),(1*4,a1)		;Volume, offset 1 long

	move.l	a0,d3				;get address of sample
	add.l	#10,d3				;skip 10 byte header
	move.l	d3,(2*4,a1)			;sample address,  offset 2 long 

	move.l	(4,a0),d3				;get sample rate
	divu.w	#156,d3				;		<--- why the hell does this work???
	and.l	#$FFFF,d3
	move.l	d3,(3*4,a1)			;pitch, offset 3 long

	move.l	(a0),d3				;get sample length
	lsl.l	#7,d3				;		<--- why the hell does this work????
	move.l	d3,(4*4,a1)			;length, offset 4 long

	move.l	#0,(5*4,a1)			; Length (WTFC) not looping, offset 5 long
	move.l	#0,(6*4,a1)			;reset to 0, offset 6 long

	cmp.l	#$00003FFF,d1			;check sound xpos that was passed in
	beq.b	.20
	cmp.w	#SCRN_RIGHT,d1
	blt.b	.10
	move.l	#0,d1				;use full right if off right side of screen
	bra.b	.30
.10:	tst.w	d1
	bpl.b	.20
	move.l	#$00007FFE,d1			;use full left if off left side of screen
	bra.b	.30
.20:	move.w	#SCRN_RIGHT,d3
	sub.w	d1,d3				;now have distance from right side
	mulu		#$49,d3				;pan per pixel * number of pixels ($7FFF / maximum xpos)
	and.l	#$0000FFFF,d3			;make sure high word is 0
	move.l	d3,d1
.30:	move.l	d1,(19*4,a1)			;set pan value

;	move.w	(8,a0),d3				;could look at 3rd entry in header to get 0 or 4 which is an index for bits
	move.l	#7*4,(a1)				;start sample, assume all samples are 8 bit (#7*4 <--- 8 bit sampler) (#3*4 <--- 16 bit sampler)

	rts


startfm::
;D0 = sound number
;D1 = sound xpos for pan value
;D2 = voice number to use

	lea		snd_addr,a0
	lsl.w	#2,d0				;sound number * 4 bytes per address
	move.l	(a0,d0.w),a0			;get address of sound info

	lea		snd_hdr_tbl,a1
	lsl.w	#2,d2				;voice number * 4
	move.l	(a1,d2.w),a1			;a1 is now the [tablestart + (n * taboff)]

	move.l	(4,a0),(1*4,a1)
	move.l	(8,a0),(2*4,a1)
	move.l	(12,a0),(3*4,a1)
	move.l	(16,a0),(4*4,a1)
	move.l	(20,a0),(5*4,a1)
	move.l	(24,a0),(6*4,a1)
	move.l	(28,a0),(7*4,a1)
	move.l	(32,a0),(8*4,a1)
	move.l	(36,a0),(9*4,a1)
	move.l	(40,a0),(10*4,a1)
	move.l	(44,a0),(11*4,a1)
	move.l	(48,a0),(12*4,a1)
	move.l	(52,a0),(13*4,a1)
	move.l	(56,a0),(14*4,a1)
	move.l	(60,a0),(15*4,a1)
	move.l	(64,a0),(16*4,a1)
	move.l	(68,a0),(17*4,a1)
	move.l	(72,a0),(18*4,a1)
;	move.l	(76,a0),(19*4,a1)

	cmp.l	#$00003FFF,d1			;check sound xpos that was passed in
	beq.b	.20
	cmp.w	#SCRN_RIGHT,d1
	blt.b	.10
	move.l	#0,d1				;use full right if off right side of screen
	bra.b	.30
.10:	tst.w	d1
	bpl.b	.20
	move.l	#$00007FFE,d1			;use full left if off left side of screen
	bra.b	.30
.20:	move.w	#SCRN_RIGHT,d3
	sub.w	d1,d3				;now have distance from right side
	mulu		#$49,d3				;pan per pixel * number of pixels ($7FFF / maximum xpos)
	and.l	#$0000FFFF,d3			;make sure high word is 0
	move.l	d3,d1
.30:	move.l	d1,(19*4,a1)			;set pan value

	move.l	(a0),(a1)				;start sound
	rts


chg_pan::
;change pan value for special weapon sound
;D0 = sound number
;D1 = sound xpos for pan value
	lea		snd_addr,a0
	lsl.w	#2,d0				;sound number * 4 bytes per address
	move.l	(a0,d0.w),a0			;get address of sound info

	lea		snd_hdr_tbl,a1
	move.l	(4,a1),a1				;use voice #1

	cmp.w	#SCRN_RIGHT,d1
	blt.b	.10
	move.l	#0,d1				;use full right if off right side of screen
	bra.b	.30
.10:	tst.w	d1
	bpl.b	.20
	move.l	#$00007FFE,d1			;use full left if off left side of screen
	bra.b	.30
.20:	move.w	#SCRN_RIGHT,d3
	sub.w	d1,d3				;now have distance from right side
	mulu		#$49,d3				;pan per pixel * number of pixels ($7FFF / maximum xpos)
	and.l	#$0000FFFF,d3			;make sure high word is 0
	move.l	d3,d1
.30:	move.l	d1,(19*4,a1)			;set pan value
	rts


chk_voices::
	lea		tablestart,a0
	lea		voicestatus,a1
	lea		sndtype,a2
	lea		snd_cnt,a3
	lea		snd_len,a4
	clr.w	d6					;count voices
.10:
	cmp.l	#-4,(a0)
	bne.b	.20					;if not -4, voice is being used
.15:	move.b	#0,(a1,d6.w)			;clear voicestatus for each voice that is unused
	move.b	#$FF,(a2,d6.w)
	move.b	#0,(a3,d6.w)			;reset snd_cnt
	bra.b	.50
.20:
	clr.w	d1
	move.b	(a2,d6.w),d1
	move.b	(a4,d1.w),d1			;get length of sound
	beq.b	.50					;if length is 0, length is not used
	add.b	#1,(a3,d6.w)			;increase current count
	cmp.b	(a3,d6.w),d1
	bcc.b	.50
	move.l	#-4,(a0)				;turn off voice when sound length is at limit
	bra.b	.15

.50:	adda.l	#taboff,a0
	add.w	#1,d6
	cmp.w	#MAX_VOICES,d6
	blt.b	.10

	cmp.b	#GAME_MODE,gamemode
	bne.b	.90
;	bsr		motorsnd				;player motor sound
	bsr		specsnd				;special weapon sound
.90:
	rts

motorsnd::
	cmp.b	#0,voicestatus			;see if motor sound ended
	bne.b	.90					;if it is still playing, leave it alone
	move.w	player+O_XPOS,d1		;xpos for pan value
	move.w	#0,d2				;use voice 0 for motor sound
	move.w	#PLRFIRE_SND,d0
	bsr		playvoice
.90:	rts

specsnd::
	tst.b	specweap+O_TYPE
	bpl		.10
	cmp.w	#BEAM,specweap+O_DESC
	bne		.90
	move.w	#1,d0
	bra		voiceoff				;if special beam is off, turn off sound

.10:	move.w	#1,d2				;use voice 1 for special weapon sound
	move.w	specweap+O_DESC,d7

	cmp.w	#SHIELD,d7
	bne.b	.20
	cmp.b	#0,voicestatus+1		;see if shield sound ended
	bne.b	.80					;if it is still playing, exit
	bra		plspecsn
.20:
	cmp.w	#BEAM,d7
	bne.b	.30
	cmp.b	#0,voicestatus+1		;see if beam sound ended
	bne.b	.80					;if it is still playing, leave it alone
	bra		plspecsn
.30:
	cmp.w	#MAGNET,d7
	bne.b	.40
	cmp.b	#0,voicestatus+1		;see if magnet sound ended
	bne.b	.80
	bra		plspecsn
.40:
	cmp.w	#BOLT,d7
	bne.b	.60
	cmp.b	#0,voicestatus+1
	bne.b	.80
	bra		plspecsn
.60:
	cmp.w	#RING,d7
	bne.b	.90
	cmp.w	#0,ringstep
	bne.b	.80					;repeat ring sound once per orbit
	bra		plspecsn
.80:
	lea		spec_snd,a0
	clr.w	d0
	move.b	(a0,d7.w),d0			;d7 is special weapon type
	move.w	specweap+O_XPOS,d1		;xpos for pan value
	bsr		chg_pan
.90:
	rts
plspecsn::
;d7 is special weapon type
;d2 is voice number to use
	lea		spec_snd,a0
	clr.w	d0
	move.b	(a0,d7.w),d0			;d7 is special weapon type
	move.w	specweap+O_XPOS,d1		;xpos for pan value
	bsr		playvoice
	rts


init_snd::
	move.l	#$00070007,D_END	; Set GOOD mode
	move.l	#0,D_CTRL			; Turn DSP off
	move.l	#0,D_FLAGS		; Set known state

; First we copy the Jerry code into Jerry
; The label GPUSTART will be created by LTXCONV/ALN at the start of the block

; The code gets loaded into the DSP at DSPORG

	move.l	#DSPORG,a1
	move.l	#GPUSTART,a0
	move.l	a0,d0
	move.l	#GPUEND,d1
	sub.l	d0,d1
	lsr.l	#2,d1
.10:	move.l	(a0)+,(a1)+
	dbra		d1,.10

; initialize voicestatus
	lea		voicestatus,a0
	move.w	#MAX_VOICES-1,d2
.15:	move.b	#0,(a0)+
	dbra		d2,.15

; Now we copy a VERY simple amplitude envelope into DSP RAM @ $f1bd00
	move.l	#simpenv,a0
	move.l	#$f1bd00,a1
	move.l	(a0)+,d1
	sub.l	#1,d1
.20:	move.l	(a0)+,(a1)+
	dbra		d1,.20

; Now we need to initialize the first long word of each "Voice table"

	move.l	#tablestart,a0
	move.l	#-4,(taboff*0,a0)
	move.l	#-4,(taboff*1,a0)
	move.l	#-4,(taboff*2,a0)
	move.l	#-4,(taboff*3,a0)
	move.l	#-4,(taboff*4,a0)
	move.l	#-4,(taboff*5,a0)
	move.l	#-4,(taboff*6,a0)
	move.l	#-4,(taboff*7,a0)
	move.l	#0, (taboff*8,a0)		;put a 0 (stop) at at last voice + 1

; Now we need to set the first long word of the "Effect table" to -1
	move.l	#-1,EFFECTPOS

; Set up the I2S interface
	move.l	#19,SCLK
	move.l	#$15,SMODE

; Now it should be safe to turn on the DSP

	move.l	#DSPORG,D_PC	; Set up D_PC
	move.l	#$1,D_CTRL	; LET 'R RIP

	rts

sndpause::
	lea		tablestart,a0				;first voice table
	lea		sndsave0,a1
	lea		sndtype,a2
	move.w	#MAX_VOICES-1,d0
.10:	move.b	(a2)+,d1					;get sndtype
	cmp.b	#$FF,d1					;not being used if $FF
	beq.b	.40
	cmp.b	#FIRST_FM,d1
	blt.b	.20
	move.l	(a0),(a1)					;save voice type instead of pitch
	move.l	#-4,(a0)					;turn off FM sound to pause it
	bra.b	.40
.20:	move.l	(12,a0),(a1)				;save pitch value in pitchsav table
	move.l	#0,(12,a0)				;set pitch to 0 to pause voice
.40:	adda.l	#taboff,a0				;go to next voice
	adda.l	#4,a1
	dbra		d0,.10
	rts

sndunpause::
	lea		tablestart,a0				;first voice table
	lea		sndsave0,a1
	lea		sndtype,a2
	move.w	#MAX_VOICES-1,d0
.10:	move.b	(a2)+,d1					;get sndtype
	cmp.b	#$FF,d1
	beq.b	.40
	cmp.b	#FIRST_FM,d1
	blt.b	.20
	move.l	(a1),(a0)					;restore voice type to unpause FM sound
	bra.b	.40
.20:	move.l	(a1),(12,a0)				;restore pitch value to unpause sound
.40:	adda.l	#taboff,a0				;go to next voice
	adda.l	#4,a1
	dbra		d0,.10
	rts

sndoff::
;turn off all sounds
	lea		tablestart,a0				;first voice table
	move.w	#MAX_VOICES-1,d0
.10:	move.l	#-4,(a0)					;turn off voice
	adda.l	#taboff,a0				;go to next voice
	dbra		d0,.10
	rts

sndoffd0::
;turn off the sound that matches the sound number in D0
;D0 = number of sound to turn off
	movem.l	a0-a1/d0-d1,-(sp)
	lea		tablestart,a0				;first voice table
	lea		sndtype,a1				;sound number
	move.w	#MAX_VOICES-1,d1
.10:	cmp.b	(a1)+,d0
	beq.b	.50
	adda.l	#taboff,a0				;go to next voice
	dbra		d1,.10
	bra.b	.90
.50:	move.l	#-4,(a0)					;turn off voice
.90:	movem.l	(sp)+,a0-a1/d0-d1
	rts

voiceoff::
;turn off voice number in D0
;D0 = voice number to turn off
	movem.l	a0,-(sp)
	lea		snd_hdr_tbl,a0
	lsl.w	#2,d0					;voice number * 4
	move.l	(a0,d0.w),a0				;a0 is now the [tablestart + (n * taboff)]
	move.l	#-4,(a0)
.90:	movem.l	(sp)+,a0
	rts

bssnd_on::
;start the 2 continuous sounds for the bosses
	cmp.w	#FINAL_LEVEL+1,level
	beq.b	.90
	move.w	levelx2,d0
	add.w	#DESRBT0_SND,d0		;add first boss sound
	move.l	#$3FFF,d1				;xpos to determine pan value
	move.w	#2,d2				;voice number
	bsr		playvoice				;d0 = sample number, d1 = sound xpos
	move.w	levelx2,d0
	add.w	#DESRBT1_SND,d0
	move.l	#$3FFF,d1				;xpos to determine pan value
	move.w	#3,d2				;voice number
	bsr		playvoice				;d0 = sample number, d1 = sound xpos
.90:	rts

bssndoff::
;turn off the 2 continuous boss sounds when game ends
	lea		tablestart,a0				;first voice table
	lea		sndtype,a1				;sound number
	move.w	#MAX_VOICES-1,d1
.10:	move.b	(a1)+,d0
	cmp.b	#DESRBT0_SND,d0
	bcs.b	.50
	cmp.b	#ODDIT1_SND+1,d0
	bcc.b	.50
	move.l	#-4,(a0)					;turn off voice
.50:	adda.l	#taboff,a0				;go to next voice
	dbra		d1,.10
	rts


bombchg::
;change the bomb sound as it drops
;D0 = new pitch value
;D1 = new modulator value
	lea		tablestart,a0				;first voice table
	lea		sndtype,a1				;sound numbers
	move.w	#MAX_VOICES-1,d7
.10:	cmp.b	#BOMB_SND,(a1)+
	beq.b	.50
	adda.l	#taboff,a0				;go to next voice
	dbra		d7,.10
	bra.b	.90
.50:	move.l	d0,16(a0)					;set new pitch
	move.l	d1,32(a0)					;set new modulator value
.90:	rts




;SOUNDS
snd_addr::					;addresses of sound data
	dc.l		samp02			;cat
	dc.l		samp03			;explos0
	dc.l		samp04			;explos1
	dc.l		samp05			;magnet
	dc.l		samp06			;player fire
	dc.l		samp07			;ringwpn
	dc.l		samp08			;shield
	dc.l		samp09			;launch
	dc.l		samp10			;tracer
	dc.l		samp11			;explos2
	dc.l		samp12			;fire
	dc.l		samp13			;blowup1
	dc.l		samp14			;blowup2
	dc.l		samp15			;blowup3
	dc.l		samp16			;buzzer
	dc.l		samp17			;electric
	dc.l		samp18			;hitnokil
	dc.l		samp19			;pickup
	dc.l		samp20			;selectx
	dc.l		samp21			;smallhit
	dc.l		fm00				;desert robot
	dc.l		fm01				;desert robot
	dc.l		fm02				;skull
	dc.l		fm03				;skull
	dc.l		fm04				;spinning cave robot
	dc.l		fm05				;spinning cave robot
	dc.l		fm06				;quetzal
	dc.l		fm07				;quetzal
	dc.l		fm08				;flying shrimp
	dc.l		fm09				;flying shrimp
	dc.l		fm10				;lion fish
	dc.l		fm11				;lion fish
	dc.l		fm12				;weird robot
	dc.l		fm13				;weird robot
	dc.l		fm14				;mud man
	dc.l		fm15				;mud man
	dc.l		fm16				;city robot
	dc.l		fm17				;city robot
	dc.l		fm18				;oddit
	dc.l		fm19				;oddit
	dc.l		fm20				;fm20
	dc.l		fm21				;fm21
	dc.l		fm22				;fm22
	dc.l		fm23				;fm23
	dc.l		beamsnd			;fm24
	dc.l		fm25				;fm25
	dc.l		fm26				;fm26
	dc.l		fm27				;fm27
	dc.l		fm28				;fm28
	dc.l		fm29				;fm29
	dc.l		bombsnd			;bomb

snd_vol::
;volume for each sample
	dc.l		$2800			;cat
	dc.l		$4000			;explos0
	dc.l		$4000			;explos1
	dc.l		$4000			;magnet
	dc.l		$2400			;player fire
	dc.l		$4000			;ringwpn
	dc.l		$4000			;shield
	dc.l		$4000			;launch
	dc.l		$4000			;tracer
	dc.l		$4000			;explos2
	dc.l		$4000			;fire
	dc.l		$4000			;blowup1
	dc.l		$4000			;blowup2
	dc.l		$4000			;blowup3
	dc.l		$4000			;buzzer
	dc.l		$4000			;electric
	dc.l		$4000			;hitnokil
	dc.l		$4000			;pickup
	dc.l		$4000			;selectx
	dc.l		$4000			;smallhit
snd_priorities::
;priority for each sound
	dc.b		110				;cat
	dc.b		150				;explos0
	dc.b		50				;explos1
	dc.b		100				;magnet
	dc.b		210				;player fire
	dc.b		100				;ringwpn
	dc.b		120				;shield
	dc.b		100				;launch
	dc.b		100				;tracer
	dc.b		72				;explos2
	dc.b		30				;fire
	dc.b		50				;blowup1
	dc.b		60				;blowup2
	dc.b		70				;blowup3
	dc.b		80				;buzzer
	dc.b		90				;electric
	dc.b		100				;hitnokil
	dc.b		70				;pickup
	dc.b		60				;selectx
	dc.b		50				;smallhit
	dc.b		250				;desert robot
	dc.b		250				;desert robot
	dc.b		250				;skull
	dc.b		250				;skull
	dc.b		250				;spinning cave robot
	dc.b		250				;spinning cave robot
	dc.b		250				;quetzal
	dc.b		250				;quetzal
	dc.b		250				;flying shrimp
	dc.b		250				;flying shrimp
	dc.b		250				;lion fish
	dc.b		250				;lion fish
	dc.b		250				;weird robot
	dc.b		250				;weird robot
	dc.b		250				;mud man
	dc.b		250				;mud man
	dc.b		250				;city robot
	dc.b		250				;city robot
	dc.b		250				;oddit
	dc.b		250				;oddit
	dc.b		80				;fm20
	dc.b		80				;fm21
	dc.b		80				;fm22
	dc.b		80				;fm23
	dc.b		80				;fm24
	dc.b		80				;fm25
	dc.b		80				;fm26
	dc.b		80				;fm27
	dc.b		80				;fm28
	dc.b		80				;fm29
	dc.b		98				;bomb sound
snd_len::
;length of each sound in frames
;0 if length is not used
	dc.b		0				;cat
	dc.b		0				;explos0
	dc.b		0				;explos1
	dc.b		0				;magnet
	dc.b		0				;player fire
	dc.b		0				;ringwpn
	dc.b		0				;shield
	dc.b		0				;launch
	dc.b		0				;tracer
	dc.b		0				;explos2
	dc.b		0				;fire
	dc.b		0				;blowup1
	dc.b		0				;blowup2
	dc.b		0				;blowup3
	dc.b		0				;buzzer
	dc.b		0				;electric
	dc.b		0				;hitnokil
	dc.b		0				;pickup
	dc.b		0				;selectx
	dc.b		0				;smallhit
	dc.b		0				;desert robot
	dc.b		0				;desert robot
	dc.b		0				;skull
	dc.b		0				;skull
	dc.b		0				;spinning cave robot
	dc.b		0				;spinning cave robot
	dc.b		0				;quetzal
	dc.b		0				;quetzal
	dc.b		0				;flying shrimp
	dc.b		0				;flying shrimp
	dc.b		0				;lion fish
	dc.b		0				;lion fish
	dc.b		0				;weird robot
	dc.b		0				;weird robot
	dc.b		0				;mud man
	dc.b		0				;mud man
	dc.b		0				;city robot
	dc.b		0				;city robot
	dc.b		0				;oddit
	dc.b		0				;oddit
	dc.b		100				;fm20
	dc.b		6				;fm21
	dc.b		40				;fm22
	dc.b		32				;fm23
	dc.b		0				;beam
	dc.b		64				;fm25
	dc.b		64				;fm26
	dc.b		64				;fm27
	dc.b		64				;fm28
	dc.b		64				;fm29
	dc.b		0				;bomb sound

	.even

snd_hdr_tbl::				;there should be MAX_VOICES entries
	dc.l		tablestart+(0*taboff), tablestart+(1*taboff),tablestart+(2*taboff),tablestart+(3*taboff)
	dc.l		tablestart+(4*taboff),tablestart+(5*taboff),tablestart+(6*taboff),tablestart+(7*taboff)


;voice type
;carrier wave
;modulator wave
;0
;pitch
;0
;volume, loop flag
;0
;modulator frequency
;modulator depth
;envelope
;envelope rate
;loop end
;loop length
;0
;0
;0
;0
;0
;pan
fm00::
;desert robot
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1DA00
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000100
	dc.l	$00F1D500
	dc.l	$00008000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
fm01::
;desert robot
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1DA00
	dc.l	$00000000
	dc.l	$000080F0
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$000000FE
	dc.l	$00F1D500
	dc.l	$00008000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00007FFF
fm02::
;skull
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00030000
	dc.l	$00000000
	dc.l	$00003000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000800
	dc.l	$00000060
	dc.l	$00000000
	dc.l	$0000C000
	dc.l	$00000040
	dc.l	$00000000
	dc.l	$00000000
fm03::
;skull
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00030000
	dc.l	$00000000
	dc.l	$00003000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00000500
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000800
	dc.l	$00000060
	dc.l	$00000000
	dc.l	$0000C000
	dc.l	$00000040
	dc.l	$00000000
	dc.l	$00007FFF
fm04::
;spinning cave robot
	dc.l	$00000004
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00000300
	dc.l	$00F1D900
	dc.l	$00003000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm05::
;spinning cave robot
	dc.l	$00000004
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00004020
	dc.l	$00001000
	dc.l	$00F1D200
	dc.l	$00010000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm06::
;quetzal
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00002E00
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00004A00
	dc.l	$00000380
	dc.l	$00F1DB00
	dc.l	$00000180
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00002000
fm07::
;quetzal
	dc.l	$00000004
	dc.l	$00F1D900
	dc.l	$00F1DE00
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$80004000
	dc.l	$00000000
	dc.l	$00000010
	dc.l	$00000300
	dc.l	$00F1DA00
	dc.l	$000002F0
	dc.l	$007FFFFF
	dc.l	$002FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00006000
fm08::
;flying shrimp
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000300
	dc.l	$00F1DB00
	dc.l	$00000200
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003000
fm09::
;flying shrimp
	dc.l	$00000010
	dc.l	$00F1D800
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00000D00
	dc.l	$00000000
	dc.l	$00001000
	dc.l	$00000000
	dc.l	$00000085
	dc.l	$00000080
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000040
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000008
	dc.l	$00001000
	dc.l	$00000000
	dc.l	$00005000
fm10::
;lion fish
	dc.l	$00000004
	dc.l	$00F1D800
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00000080
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00002000
	dc.l	$000000F0
	dc.l	$00F1DC00
	dc.l	$00001000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
fm11::
;lion fish
	dc.l	$00000004
	dc.l	$00F1D800
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00000082
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00001FFF
	dc.l	$000000F0
	dc.l	$00F1DC00
	dc.l	$00001010
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00007FFF
fm12::
;weird robot
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1DC80
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00001000
	dc.l	$00000600
	dc.l	$00F1D500
	dc.l	$00008000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00002000
fm13::
;weird robot
	dc.l	$00000004
	dc.l	$00F1D700
	dc.l	$00F1DC08
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$80003000
	dc.l	$00000000
	dc.l	$00000300
	dc.l	$00005000
	dc.l	$00F1D500
	dc.l	$00000400
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00006000
fm14::
;mud man
	dc.l	$00000004
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000000
	dc.l	$80007000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00000300
	dc.l	$00F1D900
	dc.l	$00003000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm15::
;mud man
	dc.l	$00000004
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000000
	dc.l	$80007000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00000300
	dc.l	$00F1D900
	dc.l	$00003000
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm16::
;city robot
	dc.l	$00000008
	dc.l	$00F1DE00
	dc.l	$00F1DE00
	dc.l	$00000000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$0000001F
	dc.l	$00000180
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
fm17::
;city robot
	dc.l	$00000008
	dc.l	$00F1DE00
	dc.l	$00F1DE03
	dc.l	$00000000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$0000001F
	dc.l	$0000017E
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00007FFF
fm18::
;oddit
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D400
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000000
	dc.l	$00001000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000100
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$0000003A
	dc.l	$00005000
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00003000
	dc.l	$00000000
	dc.l	$00003000
fm19::
;oddit
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D700
	dc.l	$00000000
	dc.l	$00010000
	dc.l	$00000000
	dc.l	$00002000
	dc.l	$00000000
	dc.l	$00000100
	dc.l	$00000500
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000010
	dc.l	$00001000
	dc.l	$00000000
	dc.l	$00000002
	dc.l	$000007FF
	dc.l	$00000000
	dc.l	$00005000


fm20::
	dc.l	$00000008
	dc.l	$00F1D200
	dc.l	$00F1D000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00000020
	dc.l	$00001000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm21::
	dc.l	$00000004
	dc.l	$00F1D800
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00010000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00001000
	dc.l	$00000400
	dc.l	$00F1DD00
	dc.l	$00000060
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm22::
	dc.l	$00000004
	dc.l	$00F1D800
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00000180
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00002000
	dc.l	$00000200
	dc.l	$00F1DD00
	dc.l	$0000000A
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm23::
	dc.l	$00000004
	dc.l	$00F1D800
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00010000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00000200
	dc.l	$00000040
	dc.l	$00F1DD00
	dc.l	$00000010
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
beamsnd::
	dc.l	$00000018
	dc.l	$00F1D400
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000000
	dc.l	$80003800
	dc.l	$00008200
	dc.l	$007FFFFF
	dc.l	$007FFFFF
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm25::
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$004BFFFF
	dc.l	$00000100
	dc.l	$00001800
	dc.l	$00F1DD00
	dc.l	$00003FFF
fm26::
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00008000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$004BFFFF
	dc.l	$00000100
	dc.l	$00001000
	dc.l	$004BFFFF
	dc.l	$00000100
	dc.l	$00004000
	dc.l	$00F1DD00
	dc.l	$00003FFF
fm27::
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00010000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$000C0000
	dc.l	$00000080
	dc.l	$00001000
	dc.l	$004BFFFF
	dc.l	$00000080
	dc.l	$00003000
	dc.l	$00F1DD00
	dc.l	$00003FFF
fm28::
	dc.l	$00000010
	dc.l	$00F1D200
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00006000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000040
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$000B0000
	dc.l	$00000080
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF
fm29::
	dc.l	$00000010
	dc.l	$00F1D400
	dc.l	$00F1D800
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000000
	dc.l	$00004000
	dc.l	$00000000
	dc.l	$00020000
	dc.l	$00000400
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$000B0000
	dc.l	$00000140
	dc.l	$00000800
	dc.l	$004BFFFF
	dc.l	$00000060
	dc.l	$00008000
	dc.l	$00F1DD00
	dc.l	$00003FFF



bombsnd::
	dc.l	$00000008
	dc.l	$00F1D200
	dc.l	$00F1D200
	dc.l	$00000000
	dc.l	$00040000			;pitch changes as bomb drops
	dc.l	$00000000
	dc.l	$00002C00
	dc.l	$00000000
	dc.l	$000D0000			;modulator changes as bomb drops
	dc.l	$00000200
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00000000
	dc.l	$00003FFF





simpenv::
	dc.l	18
	dc.l	$0
	dc.l	$1000
	dc.l	$2000
	dc.l	$3000
	dc.l	$4000
	dc.l	$5000
	dc.l	$6000
	dc.l	$7000
	dc.l	$7fff
	dc.l	$7000
	dc.l	$6000
	dc.l	$5000
	dc.l	$5000
	dc.l	$3000
	dc.l	$2000
	dc.l	$1000
	dc.l	$0000
	dc.l	$0000

